<div class="row">
    <div class="col-md-8">
        <h4 class="mb-2">
            {{ trans('messages.campaign.delivery_settings') }}
        </h4>
        <p>{{ trans('messages.campaign.delivery_settings.intro') }}</p>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <div>
                @foreach ([
                    \Acelle\Model\Subscriber::VERIFICATION_STATUS_UNVERIFIED,
                    \Acelle\Model\Subscriber::VERIFICATION_STATUS_DELIVERABLE,
                    \Acelle\Model\Subscriber::VERIFICATION_STATUS_RISKY,
                    \Acelle\Model\Subscriber::VERIFICATION_STATUS_UNKNOWN,
                    \Acelle\Model\Subscriber::VERIFICATION_STATUS_UNDELIVERABLE,
                    
                ] as $status)
                    <div data-control="option-container" class="d-flex mb-2">
                        <label class="me-3">
                            <input {{ in_array($status, $campaign->getDeliveryStatuses()) ? 'checked' : '' }} type="checkbox" name="delivery_statuses[]" value="{{ $status }}" id="{{ $status }}_status" class="styled"><span class="check-symbol"></span>
                        </label>
                        <div>
                            <label for="{{ $status }}_status" class="mb-0 radio-label d-inline-block">{{ trans('messages.delivery_settings.status.' . $status) }}</label>
                            <p class="text-muted mb-2 small fst-italic">
                                {{ trans('messages.delivery_settings.status.' . $status . '.wording') }}
                            </p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="d-flex w-100 ps-2 ms-3">
            <svg style="width:200px;" xmlns="http://www.w3.org/2000/svg" id="Layer_2" viewBox="0 0 909.1 911.46"><g id="Layer_2-2"><g id="object"><circle cx="454.55" cy="456.91" r="454.55" style="fill:#fff; isolation:isolate; opacity:.38;"/><g style="opacity:.62;"><rect x="155.17" y="89.11" width="598.78" height="799.06" rx="28.37" ry="28.37" transform="translate(-2.81 2.63) rotate(-.33)" style="fill:#7f7f7f;"/><path d="M201.93,855.3l8.96-.05,507.38,12.83c11.7.3,21.26-9.26,20.98-20.95l-17.65-734.1-24.54,7.21L201.93,855.3Z" style="isolation:isolate; opacity:.26;"/><rect x="185.34" y="114.56" width="538.38" height="739.28" rx="25.36" ry="25.36" transform="translate(-2.78 2.63) rotate(-.33)" style="fill:#fdfdfd;"/><path d="M204.69,115.39l362.81-2.08L181.5,439.3l-1.14-299.35c-.05-13.49,10.83-24.48,24.33-24.56Z" style="isolation:isolate; opacity:.05;"/><rect x="335.53" y="110.66" width="233.82" height="21.95" transform="translate(-.69 2.61) rotate(-.33)" style="isolation:isolate; opacity:.12;"/><path d="M520.98,43.88l-3.63.02v-2.45C517.21,18.41,495.64-.15,469.17,0l-34.86.2c-26.47.15-47.82,18.96-47.69,42v2.45l-3.61.02c-26.47.15-47.82,18.96-47.69,42l.27,46.62,233.82-1.34-.27-46.62c-.13-23.04-21.7-41.6-48.16-41.45h0ZM482.8,45.06l-61.6.35c-6.3.04-11.48-5.09-11.51-11.38-.04-6.3,5.09-11.48,11.38-11.51l61.6-.35c6.3-.04,11.48,5.09,11.51,11.38s-5.09,11.48-11.38,11.51Z" style="fill:#cecece;"/><g style="opacity:.47;"><path d="M334.82,321.89c-26.35.15-52.7.3-79.04.45-2.23.01-4.11,1.91-4.09,4.14.15,26.35.3,52.7.45,79.04,0,2.23,1.91,4.11,4.14,4.09,26.35-.15,52.7-.3,79.04-.45,1.21,0,2.12-.45,2.78-1.12.05-.04.09-.09.14-.13.02-.03.05-.05.08-.08.67-.66,1.11-1.59,1.1-2.81-.15-26.35-.3-52.7-.45-79.04-.01-2.23-1.91-4.11-4.14-4.09h0ZM331.16,400.96c-23.6.14-47.21.27-70.81.41-.14-23.6-.27-47.21-.41-70.81,23.6-.14,47.21-.27,70.81-.41.14,23.6.27,47.21.41,70.81Z" style="fill:#929292;"/><path d="M335.66,468.04c-26.35.15-52.7.3-79.04.45-2.23.01-4.11,1.91-4.09,4.14.15,26.35.3,52.7.45,79.04,0,2.23,1.91,4.11,4.14,4.09,26.35-.15,52.7-.3,79.04-.45,1.21,0,2.12-.45,2.78-1.12.05-.04.09-.09.14-.13.02-.03.05-.05.08-.08.67-.66,1.11-1.59,1.1-2.81-.15-26.35-.3-52.7-.45-79.04-.01-2.23-1.91-4.11-4.14-4.09h0ZM331.99,547.11c-23.6.14-47.21.27-70.81.41-.14-23.6-.27-47.21-.41-70.81,23.6-.14,47.21-.27,70.81-.41.14,23.6.27,47.21.41,70.81Z" style="fill:#929292;"/><path d="M336.5,614.19c-26.35.15-52.7.3-79.04.45-2.23.01-4.11,1.91-4.09,4.14.15,26.35.3,52.7.45,79.04,0,2.23,1.91,4.11,4.14,4.09,26.35-.15,52.7-.3,79.04-.45,1.21,0,2.12-.45,2.78-1.12.05-.04.09-.09.14-.13.02-.03.05-.05.08-.08.67-.66,1.11-1.59,1.1-2.81-.15-26.35-.3-52.7-.45-79.04-.01-2.23-1.91-4.11-4.14-4.09h0ZM332.83,693.26c-23.6.14-47.21.27-70.81.41-.14-23.6-.27-47.21-.41-70.81,23.6-.14,47.21-.27,70.81-.41.14,23.6.27,47.21.41,70.81Z" style="fill:#929292;"/></g><path d="M421.6,387.09c3.71-2.87,7.87-5.15,12.47-6.82,4.6-1.67,9.42-2.52,14.47-2.55s9.88.77,14.49,2.38c4.62,1.62,8.8,3.84,12.54,6.67,2.54-3.01,4.52-6.42,5.92-10.24,1.4-3.81,2.09-7.87,2.07-12.19-.06-9.73-3.52-17.99-10.4-24.79-6.88-6.8-15.18-10.17-24.9-10.11-9.73.06-17.99,3.52-24.79,10.4-6.8,6.88-10.17,15.18-10.11,24.9.02,4.31.76,8.37,2.21,12.16s3.46,7.18,6.04,10.17ZM448.48,368.94c-4.31.02-7.96-1.44-10.94-4.38s-4.48-6.57-4.51-10.89,1.44-7.96,4.38-10.94,6.57-4.48,10.89-4.51,7.96,1.44,10.94,4.38,4.48,6.57,4.51,10.89-1.44,7.96-4.38,10.94-6.57,4.48-10.89,4.51ZM448.71,408.43c-6.07.03-11.78-1.08-17.13-3.36-5.35-2.27-10.01-5.37-13.98-9.3s-7.12-8.55-9.46-13.88-3.52-11.02-3.55-17.09c-.03-6.07,1.08-11.78,3.36-17.13s5.37-10.01,9.3-13.98c3.93-3.97,8.55-7.12,13.88-9.46,5.33-2.33,11.02-3.52,17.09-3.55s11.78,1.08,17.13,3.36c5.35,2.27,10.01,5.37,13.98,9.3,3.97,3.93,7.12,8.55,9.46,13.88,2.33,5.33,3.52,11.02,3.55,17.09s-1.08,11.78-3.36,17.13-5.37,10.01-9.3,13.98c-3.93,3.97-8.55,7.12-13.88,9.46-5.33,2.33-11.02,3.52-17.09,3.55ZM448.66,399.66c3.88-.02,7.53-.61,10.96-1.76s6.57-2.8,9.41-4.94c-2.86-2.1-6.02-3.71-9.46-4.83-3.44-1.11-7.1-1.66-10.98-1.64s-7.53.61-10.96,1.76c-3.43,1.15-6.57,2.8-9.41,4.94,2.86,2.1,6.02,3.71,9.46,4.83s7.1,1.66,10.98,1.64ZM448.43,360.17c1.9-.01,3.47-.64,4.71-1.89,1.24-1.25,1.85-2.83,1.84-4.73s-.64-3.47-1.89-4.71c-1.25-1.24-2.83-1.85-4.73-1.84s-3.47.64-4.71,1.89-1.85,2.83-1.84,4.73.64,3.47,1.89,4.71,2.83,1.85,4.73,1.84Z" style="fill:#929292; opacity:.35;"/><rect x="513.19" y="377.04" width="109.72" height="28" rx="14" ry="14" style="fill:#c5e0b4;"/><rect x="513.19" y="320.28" width="150.19" height="35.9" style="fill:#929292; opacity:.32;"/><path d="M421.6,531.05c3.71-2.87,7.87-5.15,12.47-6.82,4.6-1.67,9.42-2.52,14.47-2.55s9.88.77,14.49,2.38c4.62,1.62,8.8,3.84,12.54,6.67,2.54-3.01,4.52-6.42,5.92-10.24,1.4-3.81,2.09-7.87,2.07-12.19-.06-9.73-3.52-17.99-10.4-24.79-6.88-6.8-15.18-10.17-24.9-10.11-9.73.06-17.99,3.52-24.79,10.4-6.8,6.88-10.17,15.18-10.11,24.9.02,4.31.76,8.37,2.21,12.16s3.46,7.18,6.04,10.17ZM448.48,512.9c-4.31.02-7.96-1.44-10.94-4.38s-4.48-6.57-4.51-10.89,1.44-7.96,4.38-10.94,6.57-4.48,10.89-4.51,7.96,1.44,10.94,4.38,4.48,6.57,4.51,10.89-1.44,7.96-4.38,10.94-6.57,4.48-10.89,4.51ZM448.71,552.39c-6.07.03-11.78-1.08-17.13-3.36-5.35-2.27-10.01-5.37-13.98-9.3s-7.12-8.55-9.46-13.88-3.52-11.02-3.55-17.09c-.03-6.07,1.08-11.78,3.36-17.13s5.37-10.01,9.3-13.98c3.93-3.97,8.55-7.12,13.88-9.46,5.33-2.33,11.02-3.52,17.09-3.55s11.78,1.08,17.13,3.36c5.35,2.27,10.01,5.37,13.98,9.3,3.97,3.93,7.12,8.55,9.46,13.88,2.33,5.33,3.52,11.02,3.55,17.09s-1.08,11.78-3.36,17.13-5.37,10.01-9.3,13.98c-3.93,3.97-8.55,7.12-13.88,9.46-5.33,2.33-11.02,3.52-17.09,3.55ZM448.66,543.62c3.88-.02,7.53-.61,10.96-1.76,3.43-1.15,6.57-2.8,9.41-4.94-2.86-2.1-6.02-3.71-9.46-4.83-3.44-1.11-7.1-1.66-10.98-1.64-3.88.02-7.53.61-10.96,1.76-3.43,1.15-6.57,2.8-9.41,4.94,2.86,2.1,6.02,3.71,9.46,4.83,3.44,1.11,7.1,1.66,10.98,1.64ZM448.43,504.13c1.9-.01,3.47-.64,4.71-1.89,1.24-1.25,1.85-2.83,1.84-4.73s-.64-3.47-1.89-4.71c-1.25-1.24-2.83-1.85-4.73-1.84-1.9.01-3.47.64-4.71,1.89s-1.85,2.83-1.84,4.73.64,3.47,1.89,4.71,2.83,1.85,4.73,1.84Z" style="fill:#929292; opacity:.35;"/><rect x="513.19" y="521" width="109.72" height="28" rx="14" ry="14" style="fill:#c5b4e0;"/><rect x="513.19" y="464.24" width="150.19" height="35.9" style="fill:#929292; opacity:.32;"/><path d="M426.71,672.61c3.71-2.87,7.87-5.15,12.47-6.82,4.6-1.67,9.42-2.52,14.47-2.55s9.88.77,14.49,2.38c4.62,1.62,8.8,3.84,12.54,6.67,2.54-3.01,4.52-6.42,5.92-10.24s2.09-7.87,2.07-12.19c-.06-9.73-3.52-17.99-10.4-24.79-6.88-6.8-15.18-10.17-24.9-10.11-9.73.06-17.99,3.52-24.79,10.4-6.8,6.88-10.17,15.18-10.11,24.9.02,4.31.76,8.37,2.21,12.16s3.46,7.18,6.04,10.17ZM453.59,654.46c-4.31.02-7.96-1.44-10.94-4.38s-4.48-6.57-4.51-10.89,1.44-7.96,4.38-10.94,6.57-4.48,10.89-4.51,7.96,1.44,10.94,4.38,4.48,6.57,4.51,10.89-1.44,7.96-4.38,10.94-6.57,4.48-10.89,4.51ZM453.82,693.95c-6.07.03-11.78-1.08-17.13-3.36-5.35-2.27-10.01-5.37-13.98-9.3s-7.12-8.55-9.46-13.88-3.52-11.02-3.55-17.09c-.03-6.07,1.08-11.78,3.36-17.13s5.37-10.01,9.3-13.98c3.93-3.97,8.55-7.12,13.88-9.46,5.33-2.33,11.02-3.52,17.09-3.55s11.78,1.08,17.13,3.36c5.35,2.27,10.01,5.37,13.98,9.3,3.97,3.93,7.12,8.55,9.46,13.88,2.33,5.33,3.52,11.02,3.55,17.09s-1.08,11.78-3.36,17.13-5.37,10.01-9.3,13.98c-3.93,3.97-8.55,7.12-13.88,9.46-5.33,2.33-11.02,3.52-17.09,3.55ZM453.77,685.18c3.88-.02,7.53-.61,10.96-1.76,3.43-1.15,6.57-2.8,9.41-4.94-2.86-2.1-6.02-3.71-9.46-4.83-3.44-1.11-7.1-1.66-10.98-1.64-3.88.02-7.53.61-10.96,1.76-3.43,1.15-6.57,2.8-9.41,4.94,2.86,2.1,6.02,3.71,9.46,4.83,3.44,1.11,7.1,1.66,10.98,1.64ZM453.54,645.69c1.9-.01,3.47-.64,4.71-1.89,1.24-1.25,1.85-2.83,1.84-4.73s-.64-3.47-1.89-4.71c-1.25-1.24-2.83-1.85-4.73-1.84-1.9.01-3.47.64-4.71,1.89s-1.85,2.83-1.84,4.73.64,3.47,1.89,4.71,2.83,1.85,4.73,1.84Z" style="fill:#929292; opacity:.35;"/><rect x="518.3" y="662.56" width="109.72" height="28" rx="14" ry="14" style="fill:#fbe5d6;"/><rect x="518.3" y="605.8" width="150.19" height="35.9" style="fill:#929292; opacity:.32;"/></g><polygon points="270.39 357.72 288.53 351.56 298.72 369.67 385.16 306.6 395.27 308.56 294.81 391.9 270.39 357.72" style="fill:#5cb898;"/><polygon points="268.72 508.04 286.85 501.88 297.05 519.99 383.49 456.91 393.59 458.88 293.14 542.22 268.72 508.04" style="fill:#5cb898;"/></g><line x1="275.01" y1="635.86" x2="319.44" y2="680.29" style="fill:none; stroke:#801414; stroke-linecap:round; stroke-linejoin:round; stroke-width:10px;"/><line x1="275.04" y1="680.26" x2="319.47" y2="635.83" style="fill:none; stroke:#801414; stroke-linecap:round; stroke-linejoin:round; stroke-width:10px;"/></g></svg>
        </div>
    </div>
</div>