CREATE TABLE `tracking_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `runtime_message_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int unsigned NOT NULL,
  `sending_server_id` int unsigned NOT NULL,
  `campaign_id` int unsigned DEFAULT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `error` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `auto_trigger_id` int unsigned DEFAULT NULL,
  `sub_account_id` int unsigned DEFAULT NULL,
  `email_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tracking_logs_runtime_message_id_unique` (`runtime_message_id`),
  UNIQUE KEY `tracking_logs_message_id_unique` (`message_id`),
  KEY `tracking_logs_customer_id_foreign` (`customer_id`),
  KEY `tracking_logs_sending_server_id_foreign` (`sending_server_id`),
  KEY `tracking_logs_subscriber_id_foreign` (`subscriber_id`),
  KEY `tracking_logs_auto_trigger_id_foreign` (`auto_trigger_id`),
  KEY `tracking_logs_sub_account_id_foreign` (`sub_account_id`),
  KEY `tracking_logs_email_id_foreign` (`email_id`),
  KEY `tracking_logs_campaign_id_foreign` (`campaign_id`),
  CONSTRAINT `tracking_logs_auto_trigger_id_foreign` FOREIGN KEY (`auto_trigger_id`) REFERENCES `auto_triggers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_campaign_id_foreign` FOREIGN KEY (`campaign_id`) REFERENCES `campaigns` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_email_id_foreign` FOREIGN KEY (`email_id`) REFERENCES `emails` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_sending_server_id_foreign` FOREIGN KEY (`sending_server_id`) REFERENCES `sending_servers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_sub_account_id_foreign` FOREIGN KEY (`sub_account_id`) REFERENCES `sub_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tracking_logs_subscriber_id_foreign` FOREIGN KEY (`subscriber_id`) REFERENCES `subscribers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=519325 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
